require 'fileutils'
require 'colorize'

@ficheiro = 'citas.txt'
@backup = "citas.bak"

@keyword_size = 3

@historical_edits = []

@pause_output_at = 3

Quote = Struct.new(:quotation, :author, :keywords_number)

class String

	def each
		i=0

		while i<self.length
			yield(self[i])
		end
	end
end

def again
	loop do

		print "\n\nContinuar? (s\\n): "

		option = gets.chomp

		if(option == 's' || option == 'S')
			return true
			break

		else
			if(option == 'n' || option == 'N')
				return false
				break

			else
				print "\n\nERRO: comando não reconhecido. Por favor tente outra vez.\n\n"
			end
		end
	end
end

def pause
	puts "Pressione uma tecla para continuar"
	STDIN.getc
end

def main_menu
	print "Menu Principal\n\n1) Adicionar citação\n2) Editar citação\n3) Eliminar citação\n\n4) Pesquisar citação\n5) Visualizar todas as citações\n6) Visualizar uma citação ao acaso\n\n7) Histórico de edições de hoje\n8) Número de citações\n\n9) Restaurar a base de dados de citações\n\n10) Sobre o programa\n\n0) Close Program\n\nOpção: "
	return gets.chomp()
end

def line_exists?(linha)
	begin

		file = File.open(@ficheiro, "r")

		file.each_line do |texto|
			if(texto.match(/#{linha}/) != nil)
				return true
			end 
		end

	rescue Errno::ENOENT
		return nil

	end

	return false

end

def add_quote

	loop do

		print "\n\nLinha a adicionar: "

		citação = ""

		loop do
			linha = gets

			if  linha[-2] == '"'
				linha.delete!("\n")
				citação << linha
				break;
			end

			citação << linha
		end

		print "Autor: "
		autor = gets.chomp

		print "\n\nQueres mesmo adicionar a citação? (s/n)\nOpção: "
		opção = gets.chomp

		if(opção == 's' || opção == 'S')

			if((status = line_exists?(citação)) == true)
				puts "\n\nERRO: O texto já existe\n\n"

			else
				if(status == false)
					File.open(@ficheiro, 'a'){|f| f.write("\n#{citação}\n#{autor}\n")}

				else
					File.open(@ficheiro, 'w'){|f| f.write("-== Citações ==-\n\n#{citação}\n#{autor}\n")}
				end

				@historical_edits << "#{"Adição".bold} da citação #{citação}, de #{autor}.\n\tHora: #{Time.now.strftime('%I:%M %p, %b. %d, %Y')}"
			end

			STDOUT.flush
		end

		if(again == false)
			break
		end
	end

	pause
	Kernel.system("clear")

end

def search_line(type, expr)

	begin

		file = File.open(@ficheiro, "r")

		results = []
			
		keywords = expr.split.find_all{|s| s.length>= @keyword_size}

=begin

			puts "\nkeywords contents:\n\n"                  ################# test

			i=0

			for s in keywords
				print "\tkeywords[#{i}]: #{s}"
			end

			print "\n\n"                                    ##################

=end

		if type == 1                                               # pesquisar pela citação	

			file.each_line("\n\n") do |texto|

=begin					print "\n\n\ntexto: #{texto}\n"               #teste
					texto.each_byte do |ch|
						puts ch  
					end

					print "\n\n"
=end

				if(texto.match(/-== Citações ==-/) != nil)                 
			#		puts "\n\nIdentificou corretamente o início do ficheiro.\n\n"
					next

				else
					n = 0

					for key in keywords

						#puts "\n\nkey: #{key}\n\n"

						if(texto.match(/(.*#{key}.*)\n(.+)\n/mi) != nil)
							n+=1

							if n == 1
								results << Quote.new($1, $2, n)
							end
						end
					end

					if n>1
						results[-1][:keywords_number] = n
					end

				end
			end

		else                                                     #pesquisa por autor           

			file.each_line("\n\n") do |texto|
				if(texto.match(/-== Citações ==-/) != nil)
					next
          
				else
					n = 0

					for key in keywords
						if(texto.match(/(.+)\n(.*#{key}.*)\n/mi) != nil)
							n+=1

							if n == 1
								results << Quote.new($1, $2, n)
							end
						end
					end

					if n>1
						results[-1][:keywords_number] = n
					end

				end
			end

		end


		if results.length == 0
			puts "\n\nNão foram encontradas correspondências, ao padrão, na base de dados."

		else

=begin

			for r in results                                      
				print "\n\n\nCitação: #{r[:quotation]}, Autor: #{r[:author]}\n\n\n"
			end

=end

			results.sort {|x,y| y[:keywords_number]<=>x[:keywords_number]}

			print "\n\nLista de resultados (por ordem descendente de probabilidade):\n\n"

			i=0

			for r in results do
				i+=1 
                                                                                                     
				puts "#{i})\n\tCitação: #{r[:quotation]}\n\tAutor: #{r[:author]}\n\n"
			end

		end

	return results

	rescue Errno::ENOENT
		puts "ERRO: Incapaz de abrir a base de dados. Tente outra vez."
	
	end

	return nil	

end


def search_text

	type = 0

	loop do

		loop do
			print "\n\nTipo de texto a procurar (Introduzir 1 para Citação, 2 para Autor): "
			type = gets.chomp.to_i

			# puts "\n\ntype: #{type}\n\n"

			if(type == 1 || type == 2)
				break

			else
				print "\n\nERRO: Opção não reconhecida. Insira novamente.\n"
			end
		end

		# puts "\n\ntype: #{type}\n\n"
	
		print "\nTexto a procurar: "
		text = gets.chomp

		search_line(type, text)

		status = again

		if status == false
			break
		end
	end
end

def delete_quote(record)

	begin

		fil = File.open(@ficheiro, "r")
		aux_file = File.open("aux.txt", "a")

		fil.each_line("\n\n") do |line|

=begin
					print "\n\n\ntexto: #{line}\n"               #teste

					line.each_byte do |ch|
						puts ch  
					end

					print "\n\n"

=end

			#print "\n\n\ncitação: #{record[:quotation]} autor: #{record[:author]}\n\n\n" 

			if line.match(/#{record[:quotation]}\n#{record[:author]}/) == nil
				aux_file.write(line)

			else
				@historical_edits << "#{"Eliminação".bold} da citação #{record[:quotation]}, de #{record[:author]}.\n\tHora: #{Time.now.strftime('%I:%M %p, %b. %d, %Y')}"
			end

		end

	rescue Errno::ENOENT
		puts "\n\nERRO: Incapaz de abrir a base de dados. Tente outra vez.\n\n\n"
	
	rescue IOERROR
		puts "\n\nERRO: Ocorreu algum erro de input.\n\n\n"

	ensure
		fil.close unless fil.nil?
		aux_file.close unless aux_file.nil?
	end

	FileUtils.mv("aux.txt", @ficheiro)
end

def delete_expression

	loop do

		type = 0
		expr = ""

		loop do

			print "\n\nTipo de expressão a procurar (1 - Citação / 2 - Autor): "
			type = gets.chomp.to_i

			print "\n\nExpressão a procurar: "
			expr = gets.chomp

			print "\n\n\nQuer mesmo continuar? (s/n): "
			opção = gets.chomp

			if(opção == 's' || opção == 'S')
				break
			end
		end

		results = search_line(type, expr)

		print "\n\nResultado a eliminar: "
		número = gets.chomp.to_i

		print "\n\n\nQuer mesmo continuar? (s/n): "
		opção = gets.chomp


		if(opção == 's' || opção == 'S')
			delete_quote(results[número-1])
		end

		status = again

		if status == false
			break
		end
	end
end

def edit_quote

	loop do

		if(!File.zero?(@ficheiro))

			type = 0
			expr = ""

			loop do

				print "\n\nTipo de expressão a procurar (1 - Citação / 2 - Autor): "
				type = gets.chomp.to_i

				print "\n\nExpressão a procurar: "
				expr = gets.chomp

				print "\n\n\nQuer mesmo continuar? (s/n): "
				opção = gets.chomp

				if(opção == 's' || opção == 'S')
					break
				end
			end

			results = search_line(type, expr)

			print "\n\nResultado a editar: "
			número = gets.chomp.to_i

			loop do
				print "\n\nO que editar? (1-Citação/2-Autor/-3-Ambos)\nOpção: "
				opção1 = gets.chomp.to_i

				if(opção1 == 1 || opção1 == 3)
					print("\nTexto: ")
					quote = gets.chomp
				end

				if(opção1 == 2 || opção1 == 3)
					print("\nAutor: ")
					author = gets.chomp
				end

				if(opção1>0 && opção1<4)
					break
				end
			end

			print "\n\n\nQuer mesmo continuar? (s/n): "
			opção2 = gets.chomp


			if(opção2 == 's' || opção2 == 'S')
				delete_quote(results[número-1])
			end

			trashed_quote = results[número-1][:quotation]
			trashed_author = results[número-1][:author]

			if(opção1 == 1 || opção1 == 3)
				results[número-1][:quotation] = quote
			end

			if(opção1 == 2 || opção1 == 3) 
				results[número-1][:author] = author
			end

			begin
				File.open(@ficheiro, 'a'){|f| f.write("\n#{linha}\n#{autor}\n")}

				@historical_edits << "#{"Edição".bold} de um registo, de citação #{trashed_quote} de #{trashed_author}, para citação #{results[número-1][:quotation]} de #{results[número-1][:author]}.\n\tHora: #{Time.now.strftime('%I:%M %p, %b. %d, %Y')}"

			rescue Errno::ENOENT
				print "\n\nERRO: Impossível abrir ficheiro.\n\n\n"

			rescue IOError
				print "\n\nERRO: Impossível escrever no ficheiro.\n\n\n"
			end

		else
			print "\n\nERRO: Ficheiro inexistente ou vazio\n\n\n"
		end
		
		status = again

		if status == false
			break
		end
	end

end

def display_all

	if total_number_of_quotes > 0

		file = File.open(@ficheiro)

		i = 0

		puts "\n\nLista de citações guardadas:\n\n\n"

		file.each_line("\n\n") do |texto|

			next if ($first_time_only ||=[true]).shift
		
			i+=1

			puts "#{i}º: #{texto}\n\n"

			if(i%@pause_output_at == 0)
			pause
			end

		end

		puts "\n------- Visualização terminada -------\n\n"

	else
		print "\n\nERRO: Nenhuma citação encontrada\n\n"
	end
	
	pause	
end


def total_number_of_quotes

	begin

		file = File.open(@ficheiro)

		count = 0

		file.each_line("\n\n") do
			count+= 1
		end

		return(count-1)

	rescue
		return(0)
	end
end


def display_random

	num = total_number_of_quotes

	if(num>0)

		loop do

			file = File.open(@ficheiro)

			winning_n = 1 + Random.rand(num)
			count = 1

			file.each_line("\n\n") do |line|

				if(count == 0)
					count = 1
					next
				end

				if count == winning_n
					print "\n\nCitação escolhida:\n\t#{line}\n\n"
					file.close
					break
				end

				count +=1
			end

			pause

			if again == false
				break
			end
		end

	else
		print "\n\nERRO: Nenhuma citação encontrada\n\n"
	end
	
	pause

end

def restore_quote_db

	FileUtils.cp(@backup, @ficheiro)

end

=begin
def import_quote_db

	begin

		fil = File.open(@ficheiro, "r")
		aux_file = File.open("aux.txt", "a")

		fil.each_line("\x0D\x0A") do |line|
			

			print "\n\n\ntexto: #{line}\n"               #teste

			line.each_byte do |ch|
				puts ch  
			end

			print "\n\n\n"


			aux_file.write(line.encode('UTF-8', 'ISO-8859-1', invalid: :replace, undef: :replace))
			line.gsub(/\x0D/,'')
		end
		

	rescue Errno::ENOENT
		puts "\n\nERRO: Incapaz de abrir a base de dados. Tente outra vez.\n\n\n"
	
	rescue IOError
		puts "\n\nERRO: Ocorreu algum erro de input.\n\n\n"

	ensure
		fil.close unless fil.nil?
		aux_file.close unless aux_file.nil?
	end

	FileUtils.mv("aux.txt", @ficheiro)
end

=end

def today_edit_history

	print "Histórico de edição de hoje:\n\n"

	i = 0

	for s in @historical_edits
		i = i+1

		print"#{i}º: #{s}\n\n"
	end

	if @historical_edits == []
		print "Hoje ainda não houve edição da base de dados.\n\n\n"

	else
		print "\n"
	end
		
	pause

end


def print_number_quotes

	file = File.open(@ficheiro, "r")

	count = 0

	file.each_line("\n\n") do |line|
		if line.match(/.+\n.+\n/m)
			count += 1
		end
	end

	print "\n\nO número de citações na base de dados é #{count.to_s}.\n\n"

	pause

end

def about

	print "\n\nBase de dados de citações v1.7\n\tpor J\n\n\n"

	pause

end

loop do
	Kernel.system("clear")

	m = main_menu.match(/\d+/)

	if(m!= nil)
		option = m[0].to_i

	else
		option = -1

	end

	Kernel.system("clear")

	case option
		when 0
			if File.file?(@ficheiro)
				FileUtils.cp(@ficheiro, @backup)
			end

			puts "Matane, bye, hasta en breve, à bientôt, bis dann, ciao, até já."
			break

		when 1
			add_quote

		when 2
			edit_quote

		when 3
			delete_expression

		when 4
			search_text

		when 5
			display_all

		when 6
			display_random

		when 7
			today_edit_history

		#when 6
			#import_quote_db

		when 8
			print_number_quotes

		when 9
			restore_quote_db

		when 10
			about

		else
			print "Aviso: Opção não reconhecida.\n\n"
			pause

			Kernel.system("clear")
	end

end